/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.shells;

import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorKeyListener;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.controller.GrammarEditorShell.JPGraphMouseListener;
import net.nooj4nlp.controller.GrammarEditorShell.JPGraphMouseMotionListener;
import net.nooj4nlp.controller.GrammarEditorShell.JPGraphMouseWheelListener;
import net.nooj4nlp.controller.GrammarEditorShell.TextBoxKeyListener;
import net.nooj4nlp.controller.HistoryDialog.BackActionListener;
import net.nooj4nlp.controller.HistoryDialog.ForwardActionListener;
import net.nooj4nlp.controller.HistoryDialog.PurgeActionListener;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.gui.actions.grammar.CopyActionListener;
import net.nooj4nlp.gui.actions.grammar.CreateNewNodeActionListener;
import net.nooj4nlp.gui.actions.grammar.CutActionListener;
import net.nooj4nlp.gui.actions.grammar.DeleteGraphActionListener;
import net.nooj4nlp.gui.actions.grammar.DeleteGraphAndChildrenActionListener;
import net.nooj4nlp.gui.actions.grammar.ExportGrammarActionListener;
import net.nooj4nlp.gui.actions.grammar.ImportGrammarActionListener;
import net.nooj4nlp.gui.actions.grammar.NewGraphActionListener;
import net.nooj4nlp.gui.actions.grammar.PasteActionListener;
import net.nooj4nlp.gui.actions.grammar.SelectAllActionListener;
import net.nooj4nlp.gui.actions.shells.construct.AlignmentActionListener;
import net.nooj4nlp.gui.actions.shells.construct.ContractActionListener;
import net.nooj4nlp.gui.actions.shells.construct.DebugActionListener;
import net.nooj4nlp.gui.actions.shells.construct.GenerateLanguageActionListener;
import net.nooj4nlp.gui.actions.shells.construct.GramStructActionListener;
import net.nooj4nlp.gui.actions.shells.construct.HistoryDialogActionListener;
import net.nooj4nlp.gui.actions.shells.construct.PresentationActionListener;
import net.nooj4nlp.gui.actions.shells.control.GrammarCommandInternalFrameListener;
import net.nooj4nlp.gui.components.JPGraph;
import net.nooj4nlp.gui.dialogs.HistoryDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.ContractShell;
import net.nooj4nlp.gui.shells.GramStructShell;

public class GrammarEditorShell
extends JInternalFrame {
    private static final long serialVersionUID = 2202250733280414442L;
    public JPopupMenu popText;
    public JMenu grammarMenu;
    public JMenu GrammarEditMenu;
    public JLabel info;
    public JTextArea rtBox;
    public JPanel pBackGraph;
    public JPGraph pGraph;
    public Timer timerSel;
    private JMenuItem mntmShowStructure;
    private JMenuItem mntmDebug;
    private JMenuItem mntmShowContract;
    public GramStructShell gramStruct;
    private GrammarEditorShellController controller;
    public GramStructShell formGramStruct;
    public ContractShell contractShell;
    private JCheckBoxMenuItem mntmZoom30;
    private JCheckBoxMenuItem mntmZoom50;
    private JCheckBoxMenuItem mntmZoom75;
    private JCheckBoxMenuItem mntmZoom100;
    private JCheckBoxMenuItem mntmZoom125;
    private JCheckBoxMenuItem mntmZoom150;
    private JCheckBoxMenuItem mntmZoom200;

    public GrammarEditorShell(Language lan, Language lan2) {
        this.construct();
        this.controller = new GrammarEditorShellController(this, lan, lan2);
        this.formGramStruct = new GramStructShell(this);
        this.pGraph.addMouseMotionListener(new JPGraphMouseMotionListener(this));
        this.pGraph.addMouseListener(new JPGraphMouseListener(this));
        this.pGraph.addMouseWheelListener(new JPGraphMouseWheelListener(this));
        this.addKeyListener(new GrammarEditorKeyListener(this));
        this.rtBox.addKeyListener(new TextBoxKeyListener(this));
        this.rtBox.getDocument().putProperty("__EndOfLine__", "\n");
        this.popText = this.createPopupMenu();
        this.grammarMenu = this.createGrammarMenu();
        this.GrammarEditMenu = this.createGrammarEditMenu();
        this.addInternalFrameListener(new GrammarCommandInternalFrameListener(this.controller));
    }

    public GrammarEditorShell(String fullname) {
        this.construct();
        this.controller = new GrammarEditorShellController(this, fullname);
        this.formGramStruct = new GramStructShell(this);
        this.pGraph.addMouseMotionListener(new JPGraphMouseMotionListener(this));
        this.pGraph.addMouseListener(new JPGraphMouseListener(this));
        this.pGraph.addMouseWheelListener(new JPGraphMouseWheelListener(this));
        this.addKeyListener(new GrammarEditorKeyListener(this));
        this.rtBox.addKeyListener(new TextBoxKeyListener(this));
        this.popText = this.createPopupMenu();
        this.grammarMenu = this.createGrammarMenu();
        this.GrammarEditMenu = this.createGrammarEditMenu();
        this.addInternalFrameListener(new GrammarCommandInternalFrameListener(this.controller));
    }

    private void construct() {
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setClosable(true);
        this.setBounds(100, 100, 950, 400);
        this.setPreferredSize(new Dimension(1200, 800));
        this.getContentPane().setLayout((LayoutManager)new MigLayout("ins 7", "[grow,fill]", "[grow,fill]"));
        this.rtBox = new JTextArea();
        this.rtBox.setBorder(BorderFactory.createLoweredBevelBorder());
        this.info = new JLabel();
        this.pBackGraph = new JPanel();
        this.pBackGraph.setLayout((LayoutManager)new MigLayout("", "[grow,fill]", "[grow,fill]"));
        this.pBackGraph.setPreferredSize(new Dimension(1047, 763));
        this.pGraph = new JPGraph(this);
        this.pBackGraph.add(this.pGraph);
        JScrollPane graphScrollPane = new JScrollPane(this.pBackGraph);
        this.getContentPane().add(graphScrollPane);
        this.pGraph.setLayout(null);
        this.pGraph.add(this.rtBox);
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu pop = new JPopupMenu();
        this.mntmShowStructure = new JMenuItem("Show Structure");
        this.mntmShowStructure.addActionListener(new GramStructActionListener(this));
        pop.add(this.mntmShowStructure);
        JMenu mnHistory = new JMenu("History");
        pop.add(mnHistory);
        JMenuItem mntmShow = new JMenuItem("Show");
        mnHistory.add(mntmShow);
        mntmShow.addActionListener(new HistoryDialogActionListener(this));
        JMenuItem mntmPurge = new JMenuItem("Purge");
        mnHistory.add(mntmPurge);
        mntmPurge.addActionListener(new PurgeActionListener(this));
        JMenuItem mntmShowContract = new JMenuItem("Show Contract");
        mntmShowContract.addActionListener(new ContractActionListener(this));
        pop.add(mntmShowContract);
        this.mntmDebug = new JMenuItem("Debug...");
        this.mntmDebug.addActionListener(new DebugActionListener(this.controller));
        pop.add(this.mntmDebug);
        JSeparator separator_1 = new JSeparator();
        pop.add(separator_1);
        JMenuItem mntmGenerateLanguage = new JMenuItem("Generate Language...");
        mntmGenerateLanguage.addActionListener(new GenerateLanguageActionListener(this.controller));
        pop.add(mntmGenerateLanguage);
        JSeparator separator_2 = new JSeparator();
        pop.add(separator_2);
        JMenuItem mntmAlignmnet = new JMenuItem("Alignment");
        mntmAlignmnet.addActionListener(new AlignmentActionListener(this.controller));
        pop.add(mntmAlignmnet);
        JMenuItem mntmPresentation = new JMenuItem("Presentation");
        mntmPresentation.addActionListener(new PresentationActionListener(this.controller));
        pop.add(mntmPresentation);
        JSeparator separator_3 = new JSeparator();
        pop.add(separator_3);
        this.GrammarEditMenu = this.createGrammarEditMenu();
        pop.add(this.GrammarEditMenu);
        JSeparator separator_4 = new JSeparator();
        pop.add(separator_4);
        JMenuItem mntmNewGraph = new JMenuItem("New Graph");
        mntmNewGraph.addActionListener(new NewGraphActionListener(this));
        pop.add(mntmNewGraph);
        JMenuItem mntmDeleteGraph = new JMenuItem("Delete Graph");
        mntmDeleteGraph.addActionListener(new DeleteGraphActionListener(this));
        pop.add(mntmDeleteGraph);
        JMenuItem mntmDeleteGraphChildren = new JMenuItem("Delete Graph & Children");
        mntmDeleteGraphChildren.addActionListener(new DeleteGraphAndChildrenActionListener(this.controller));
        pop.add(mntmDeleteGraphChildren);
        JMenuItem mntmImportGrammar = new JMenuItem("Import Grammar");
        pop.add(mntmImportGrammar);
        mntmImportGrammar.addActionListener(new ImportGrammarActionListener(this));
        JMenuItem mntmExportGrammar = new JMenuItem("Export Grammar");
        pop.add(mntmExportGrammar);
        mntmExportGrammar.addActionListener(new ExportGrammarActionListener(this));
        return pop;
    }

    private JMenu createGrammarEditMenu() {
        JMenu mnEdit_1 = new JMenu("Edit");
        JMenuItem mntmCreateNewNode = new JMenuItem("Create New Node");
        mntmCreateNewNode.addActionListener(new CreateNewNodeActionListener(this));
        mnEdit_1.add(mntmCreateNewNode);
        JMenuItem mntmCopy = new JMenuItem("Copy");
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 || System.getProperty("os.name").toLowerCase().indexOf("lin") >= 0) {
            mntmCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        } else {
            mntmCopy.setAccelerator(KeyStroke.getKeyStroke(67, 256));
        }
        mntmCopy.addActionListener(new CopyActionListener(this));
        mnEdit_1.add(mntmCopy);
        JMenuItem mntmCut = new JMenuItem("Cut");
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 || System.getProperty("os.name").toLowerCase().indexOf("lin") >= 0) {
            mntmCut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        } else {
            mntmCut.setAccelerator(KeyStroke.getKeyStroke(88, 256));
        }
        mntmCut.addActionListener(new CutActionListener(this));
        mnEdit_1.add(mntmCut);
        JMenuItem mntmPaste = new JMenuItem("Paste");
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 || System.getProperty("os.name").toLowerCase().indexOf("lin") >= 0) {
            mntmPaste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        } else {
            mntmPaste.setAccelerator(KeyStroke.getKeyStroke(86, 256));
        }
        mntmPaste.addActionListener(new PasteActionListener(this));
        mnEdit_1.add(mntmPaste);
        JMenuItem mntmSelectAll = new JMenuItem("Select All");
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 || System.getProperty("os.name").toLowerCase().indexOf("lin") >= 0) {
            mntmSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        } else {
            mntmSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 256));
        }
        mntmSelectAll.addActionListener(new SelectAllActionListener(this));
        mnEdit_1.add(mntmSelectAll);
        JSeparator separator_1 = new JSeparator();
        mnEdit_1.add(separator_1);
        JMenuItem mntmUndo = new JMenuItem("Undo");
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 || System.getProperty("os.name").toLowerCase().indexOf("lin") >= 0) {
            mntmUndo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        } else {
            mntmUndo.setAccelerator(KeyStroke.getKeyStroke(90, 4));
        }
        mnEdit_1.add(mntmUndo);
        mntmUndo.addActionListener(new BackActionListener(this, HistoryDialog.controller));
        JMenuItem mntmRedo = new JMenuItem("Redo");
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 || System.getProperty("os.name").toLowerCase().indexOf("lin") >= 0) {
            mntmRedo.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        } else {
            mntmRedo.setAccelerator(KeyStroke.getKeyStroke(89, 4));
        }
        mnEdit_1.add(mntmRedo);
        mntmRedo.addActionListener(new ForwardActionListener(this, HistoryDialog.controller));
        return mnEdit_1;
    }

    private JMenu createZoomMenu() {
        JMenu mnZoom = new JMenu("Zoom");
        this.mntmZoom30 = new JCheckBoxMenuItem("30%");
        this.mntmZoom30.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrammarEditorShell.this.controller.zoom(30);
                GrammarEditorShell.this.mntmZoom30.setSelected(true);
                GrammarEditorShell.this.mntmZoom50.setSelected(false);
                GrammarEditorShell.this.mntmZoom75.setSelected(false);
                GrammarEditorShell.this.mntmZoom100.setSelected(false);
                GrammarEditorShell.this.mntmZoom125.setSelected(false);
                GrammarEditorShell.this.mntmZoom150.setSelected(false);
                GrammarEditorShell.this.mntmZoom200.setSelected(false);
            }
        });
        mnZoom.add(this.mntmZoom30);
        this.mntmZoom50 = new JCheckBoxMenuItem("50%");
        this.mntmZoom50.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrammarEditorShell.this.controller.zoom(50);
                GrammarEditorShell.this.mntmZoom30.setSelected(false);
                GrammarEditorShell.this.mntmZoom50.setSelected(true);
                GrammarEditorShell.this.mntmZoom75.setSelected(false);
                GrammarEditorShell.this.mntmZoom100.setSelected(false);
                GrammarEditorShell.this.mntmZoom125.setSelected(false);
                GrammarEditorShell.this.mntmZoom150.setSelected(false);
                GrammarEditorShell.this.mntmZoom200.setSelected(false);
            }
        });
        mnZoom.add(this.mntmZoom50);
        this.mntmZoom75 = new JCheckBoxMenuItem("75%");
        this.mntmZoom75.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrammarEditorShell.this.controller.zoom(75);
                GrammarEditorShell.this.mntmZoom30.setSelected(false);
                GrammarEditorShell.this.mntmZoom50.setSelected(false);
                GrammarEditorShell.this.mntmZoom75.setSelected(true);
                GrammarEditorShell.this.mntmZoom100.setSelected(false);
                GrammarEditorShell.this.mntmZoom125.setSelected(false);
                GrammarEditorShell.this.mntmZoom150.setSelected(false);
                GrammarEditorShell.this.mntmZoom200.setSelected(false);
            }
        });
        mnZoom.add(this.mntmZoom75);
        this.mntmZoom100 = new JCheckBoxMenuItem("100%");
        this.mntmZoom100.setSelected(true);
        this.mntmZoom100.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrammarEditorShell.this.controller.zoom(100);
                GrammarEditorShell.this.mntmZoom30.setSelected(false);
                GrammarEditorShell.this.mntmZoom50.setSelected(false);
                GrammarEditorShell.this.mntmZoom75.setSelected(false);
                GrammarEditorShell.this.mntmZoom100.setSelected(true);
                GrammarEditorShell.this.mntmZoom125.setSelected(false);
                GrammarEditorShell.this.mntmZoom150.setSelected(false);
                GrammarEditorShell.this.mntmZoom200.setSelected(false);
            }
        });
        mnZoom.add(this.mntmZoom100);
        this.mntmZoom125 = new JCheckBoxMenuItem("125%");
        this.mntmZoom125.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrammarEditorShell.this.controller.zoom(125);
                GrammarEditorShell.this.mntmZoom30.setSelected(false);
                GrammarEditorShell.this.mntmZoom50.setSelected(false);
                GrammarEditorShell.this.mntmZoom75.setSelected(false);
                GrammarEditorShell.this.mntmZoom100.setSelected(false);
                GrammarEditorShell.this.mntmZoom125.setSelected(true);
                GrammarEditorShell.this.mntmZoom150.setSelected(false);
                GrammarEditorShell.this.mntmZoom200.setSelected(false);
            }
        });
        mnZoom.add(this.mntmZoom125);
        this.mntmZoom150 = new JCheckBoxMenuItem("150%");
        this.mntmZoom150.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrammarEditorShell.this.controller.zoom(150);
                GrammarEditorShell.this.mntmZoom30.setSelected(false);
                GrammarEditorShell.this.mntmZoom50.setSelected(false);
                GrammarEditorShell.this.mntmZoom75.setSelected(false);
                GrammarEditorShell.this.mntmZoom100.setSelected(false);
                GrammarEditorShell.this.mntmZoom125.setSelected(false);
                GrammarEditorShell.this.mntmZoom150.setSelected(true);
                GrammarEditorShell.this.mntmZoom200.setSelected(false);
            }
        });
        mnZoom.add(this.mntmZoom150);
        this.mntmZoom200 = new JCheckBoxMenuItem("200%");
        this.mntmZoom200.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrammarEditorShell.this.controller.zoom(200);
                GrammarEditorShell.this.mntmZoom30.setSelected(false);
                GrammarEditorShell.this.mntmZoom50.setSelected(false);
                GrammarEditorShell.this.mntmZoom75.setSelected(false);
                GrammarEditorShell.this.mntmZoom100.setSelected(false);
                GrammarEditorShell.this.mntmZoom125.setSelected(false);
                GrammarEditorShell.this.mntmZoom150.setSelected(false);
                GrammarEditorShell.this.mntmZoom200.setSelected(true);
            }
        });
        mnZoom.add(this.mntmZoom200);
        return mnZoom;
    }

    private JMenu createGrammarMenu() {
        Launcher.mnEdit.setVisible(false);
        JMenu pop = new JMenu("GRAMMAR");
        this.mntmShowStructure = new JMenuItem("Show Structure");
        this.mntmShowStructure.addActionListener(new GramStructActionListener(this));
        pop.add(this.mntmShowStructure);
        JMenu mnHistory = new JMenu("History");
        pop.add(mnHistory);
        JMenuItem mntmShow = new JMenuItem("Show");
        mnHistory.add(mntmShow);
        mntmShow.addActionListener(new HistoryDialogActionListener(this));
        JMenuItem mntmPurge = new JMenuItem("Purge");
        mnHistory.add(mntmPurge);
        mntmPurge.addActionListener(new PurgeActionListener(this));
        JMenuItem mntmShowContract = new JMenuItem("Show Contract");
        mntmShowContract.addActionListener(new ContractActionListener(this));
        pop.add(mntmShowContract);
        this.mntmDebug = new JMenuItem("Debug...");
        this.mntmDebug.addActionListener(new DebugActionListener(this.controller));
        pop.add(this.mntmDebug);
        JSeparator separator_1 = new JSeparator();
        pop.add(separator_1);
        JMenuItem mntmGenerateLanguage = new JMenuItem("Generate Language...");
        mntmGenerateLanguage.addActionListener(new GenerateLanguageActionListener(this.controller));
        pop.add(mntmGenerateLanguage);
        JSeparator separator_2 = new JSeparator();
        pop.add(separator_2);
        JMenuItem mntmAlignmnet = new JMenuItem("Alignment");
        mntmAlignmnet.addActionListener(new AlignmentActionListener(this.controller));
        pop.add(mntmAlignmnet);
        JMenuItem mntmPresentation = new JMenuItem("Presentation");
        mntmPresentation.addActionListener(new PresentationActionListener(this.controller));
        pop.add(mntmPresentation);
        JMenu mnZoom = this.createZoomMenu();
        pop.add(mnZoom);
        JSeparator separator_3 = new JSeparator();
        pop.add(separator_3);
        JMenuItem mntmNewGraph = new JMenuItem("New Graph");
        mntmNewGraph.addActionListener(new NewGraphActionListener(this));
        pop.add(mntmNewGraph);
        JMenuItem mntmDeleteGraph = new JMenuItem("Delete Graph");
        mntmDeleteGraph.addActionListener(new DeleteGraphActionListener(this));
        pop.add(mntmDeleteGraph);
        JMenuItem mntmImportGrammar = new JMenuItem("Import Grammar");
        pop.add(mntmImportGrammar);
        mntmImportGrammar.addActionListener(new ImportGrammarActionListener(this));
        JMenuItem mntmExportGrammar = new JMenuItem("Export Grammar");
        pop.add(mntmExportGrammar);
        mntmExportGrammar.addActionListener(new ExportGrammarActionListener(this));
        return pop;
    }

    public JMenuItem getMntmShowStructure() {
        return this.mntmShowStructure;
    }

    public JMenuItem getMntmDebug() {
        return this.mntmDebug;
    }

    public JMenuItem getMntmShowContract() {
        return this.mntmShowContract;
    }

    public GrammarEditorShellController getController() {
        return this.controller;
    }

    public JTextArea getRtBox() {
        return this.rtBox;
    }
}

